<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class JobApplication extends Model
{
    protected $table = 'job_applications';
    protected $primaryKey = 'Application_id';
    public $timestamps = true;

    // Define custom timestamp columns
    const CREATED_AT = 'Applied_at';
    const UPDATED_AT = 'Updated_at';

    protected $fillable = [
        'User_id',
        'Job_id',
        'Resume_url',
        'Cover_letter',
        'Status',
        'Rating',
        'Screening_score',
        'Overall_score',
    ];

    protected $casts = [
        'Status' => 'string',
        'Applied_at' => 'datetime',
        'Updated_at' => 'datetime',
        'Rating' => 'decimal:3',
        'Screening_score' => 'decimal:2',
        'Overall_score' => 'decimal:2',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'User_id', 'User_id');
    }

    public function job()
    {
        return $this->belongsTo(Job::class, 'Job_id', 'Job_id');
    }
}
